package gov.va.med.mhv.sm.admin.jpa.repository;

import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import gov.va.med.mhv.sm.admin.jpa.model.Clinician;
import gov.va.med.mhv.sm.admin.jpa.model.SMPatient;
import gov.va.med.mhv.sm.admin.jpa.model.SMUser;

@Repository
public interface SMUserRepository extends JpaRepository<SMUser, Long>{

	/**
	 *
	 * @param firstName
	 * @param lastName
	 * @param nssn
	 * @return List<SMPatient>
	 */
	@Query("Select pa from SMPatient pa,PatientFacility pf where pa.id=pf.userId "
			+ "and pa.firstName like %?1% and pa.lastName like %?2% and nssn like %?3% "
			+ "and pf.stationNumber=?4")
	List<SMPatient> getPatientByNameAndNSSN(@Param("firstName") String firstName,
			@Param("lastName") String lastName, @Param("nssn") String nssn,@Param("facilityId") Long facilityId);
	
	/**
	 *
	 * @param facilityId
	 * @return List<Clinician>
	 */
	@Query("Select clin from Clinician clin where clin.stationNo=:station and clin.active=1")
	List<Clinician> getCliniciansByStation(@Param("station") String station);

}